set sql_safe_updates=0;

-- Appointment

SET @sgAppointmentDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='CREATE_ENQUIRY_OWNER_RECIPIENTS');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
        T1.id AS ID,
        T1.code AS ENQUIRY_CODE,
        T1.firstName AS STUDENT_FIRSTNAME,
        T1.lastName AS STUDENT_LASTNAME,
        T2.fatherFirstName AS PARENT_FIRSTNAME,
        T2.fatherLastName AS PARENT_LASTNAME, 
        T4.firstName as FIRST_NAME,
        T4.lastName as LAST_NAME,
        T4.emailId AS EMAIL_ID,
        T4.mobileNumber AS MOBILE_NO,
        T2.mobileCountryCode AS MOBILE_CODE,
        T5.displayName AS ACADEMY_NAME_LOCATION,
        T5.academyName AS ACADEMY_NAME,
    (Case 
    when T5.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T5.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T5.logoUrl)end) as LOGO_URL,
    (Case when T5.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T5.headerUrl) 
    else NULL end) as HEADER_URL,
        (Case when T5.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T5.footerUrl) 
    else NULL end) as FOOTER_URL       
    FROM
        enquiry T1
            LEFT JOIN
        enq_student_details T2 ON T2.enquiryId = T1.id    
            LEFT JOIN 
        staffs T3 on T1.assignedToUserId=T3.userId
            LEFT JOIN
        persons T4 on T4.id=T3.personId
            LEFT JOIN
        academy_location T5 ON T5.id = T1.academyLocationId
            LEFT JOIN
        academy_location_addresses T6 ON T6.academyLocationId = T5.id
            LEFT JOIN
        address T7 ON T7.id = T6.addressId
            LEFT JOIN
        organizations org on org.id = 1
    WHERE
        T1.id IN (namedParams)",`jsonString` = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "ENQUIRY_CODE",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "firstName",
            "resultKey": "PARENT_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "lastName",
            "resultKey": "PARENT_LASTNAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "studentFirstName",
            "resultKey": "STUDENT_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "studentLastName",
            "resultKey": "STUDENT_LASTNAME",
            "displayCode": "",
            "displayOrder": 4
        },{
            "id": 6,
            "value": "studentLastName",
            "resultKey": "FIRST_NAME",
            "displayCode": "",
            "displayOrder": 5
        },{
            "id": 7,
            "value": "studentLastName",
            "resultKey": "LAST_NAME",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "logoUrl",
            "resultKey": "LOGO_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "headerUrl",
            "resultKey": "HEADER_URL",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "footerUrl",
            "resultKey": "FOOTER_URL",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 10
        },
        {
            "id": 12,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 11
        }
    ]
}' WHERE `dataProviderId` = @sgAppointmentDT;

-- Msg Template
SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='CREATE_ENQUIRY_OWNER');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='CREATE_ENQUIRY_OWNER');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='CREATE_ENQUIRY_OWNER_RECIPIENTS');
SET @msgMessageTypeId=(SELECT id FROM `msg_message_type` WHERE `code`='Notifications'); 

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Create Enquiry Owner Buzz Template',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId,@msgMessageTypeId,@templatedtproviderId+1,NULL,'Create Enquiry Owner Buzz Template',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Welcome - We can’t wait to meet you!','<html>
<head>
    <title></title>
</head>
<body>
<img height="80" width="100%" src="$recipientData[&quot;HEADER_URL&quot;]"/>
<p>Lead ID&nbsp;<strong>$recipientData[&quot;ENQUIRY_CODE&quot;]</strong></p>

<p>Dear&nbsp;<strong>$recipientData[&quot;STUDENT_FIRSTNAME&quot;]&nbsp;$recipientData[&quot;STUDENT_LASTNAME&quot;]</strong></p>

<p>Thank you for your interest in <strong>$recipientData[&quot;STUDENT_FIRSTNAME&quot;]&nbsp;$recipientData[&quot;STUDENT_LASTNAME&quot;]</strong>&nbsp;joining our ever-growing <strong>$templateData[&quot;ACADEMY_NAME&quot;]</strong>&nbsp;community. We look forward to a long and prosperous relationship with both you and your child. In fact, we have a dedicated team of staff who are ready and waiting to answer any questions you may have.</p>

<p><strong>What&rsquo;s the next step?</strong></p>

<p>If you require more information on our school or require any further assistance, please click here<br />
<strong>$recipientData[&quot;ACADEMY_EMAIL&quot;]</strong>&nbsp;and the school will contact you telephonically to discuss.</p>

<p><br />
If you are interested in applying for admission to our school, please click here <strong>$recipientData[&quot;WEBSITE_URL&quot;]</strong>&nbsp;to get the process started. Your application will be assessed and, depending on the grade (form or standard) you are enquiring for, an assessment/interview may be scheduled. If the assessment/interview has been successful, you will receive a &ldquo;Conditional Admission&rdquo; letter and on acceptance of the offer you will be able to complete the admission process by paying the relevant enrolment fee or submitting other required information as applicable.</p>

<p>We can&rsquo;t wait to hear back from you!</p>

<p>Kind regards,<br />
<strong>$templateData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong></p>
<img height="80" width="100%" src="$recipientData[&quot;FOOTER_URL&quot;]" />
</body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES(@msgtemplateId+3,@msgtemplateconfigId+1,'2',NULL,'Dear $recipientData["STUDENT_FIRSTNAME"] $recipientData["STUDENT_LASTNAME"],
Thank you for your interest in our school. We will be touch shortly. 
$templateData[&quot;ACADEMY_NAME_LOCATION&quot;]');

set sql_safe_updates=1;